/*
 * @brief SCTimer/PWM (SCT) Match Toggle example
 *
 * @note
 * Copyright(C) NXP Semiconductors, 2014
 * All rights reserved.
 *
 * @par
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * LPC products.  This software is supplied "AS IS" without any warranties of
 * any kind, and NXP Semiconductors and its licensor disclaim any and
 * all warranties, express or implied, including all implied warranties of
 * merchantability, fitness for a particular purpose and non-infringement of
 * intellectual property rights.  NXP Semiconductors assumes no responsibility
 * or liability for the use of the software, conveys no license or rights under any
 * patent, copyright, mask work right, or any other intellectual property rights in
 * or to any products. NXP Semiconductors reserves the right to make changes
 * in the software without notification. NXP Semiconductors also makes no
 * representation or warranty that such application will be suitable for the
 * specified use without further testing or modification.
 *
 * @par
 * Permission to use, copy, modify, and distribute this software and its
 * documentation is hereby granted, under NXP Semiconductors' and its
 * licensor's relevant copyrights in the software, without fee, provided that it
 * is used in conjunction with NXP Semiconductors microcontrollers.  This
 * copyright, permission, and disclaimer notice must appear in all copies of
 * this code.
 */

#include "board.h"


/*****************************************************************************
 * Private types/enumerations/variables
 ****************************************************************************/

/*****************************************************************************
 * Public types/enumerations/variables
 ****************************************************************************/

/*****************************************************************************
 * Private functions
 ****************************************************************************/

/*****************************************************************************
 * Public functions
 ****************************************************************************/


void SCT_Init(void)
{

	Chip_SCT_Init(LPC_SCT);			                  																	// enable the SCT clock

	Chip_SCT_Config(LPC_SCT, 	SCT_CONFIG_16BIT_COUNTER 	|
	                         SCT_CONFIG_AUTOLIMIT_L 		);													// two 16 bit timers, auto limit

		Chip_Clock_SetMain_A_ClockSource(SYSCON_MAIN_A_CLKSRC_FRO12MHZ);							// Set Main Clock (SCT Clock) as 12MHz
		Chip_SCT_SetControl(LPC_SCT, SCT_CTRL_PRE_L(119));					           				// PRE_L[12:5] = 120-1 (SCT clock = 12MHz/120 = 100 KHz)

		Chip_SCT_SetMatchReload(LPC_SCT, SCT_MATCH_0, (100000/10)-1);									// match 0 @ 10 Hz = 100 msec

		Chip_SCT_EventStateMask(LPC_SCT, 0 , ENABLE_ALL_STATES);			  							// event 0 happens in all state
		Chip_SCT_EventControl(LPC_SCT, 0 , SCT_COMBMODE_MATCH);												// match 0 condition only

		Chip_SCT_SetOutput(LPC_SCT, SCT_OUTPUT_4 , SCT_EVT_0);					      				// event 0 will set   SCT0_OUT4
		Chip_SCT_ClearOutput(LPC_SCT, SCT_OUTPUT_4, SCT_EVT_0);				      					// event 0 will clear SCT0_OUT4

		Chip_SCT_SetConflictResolution(LPC_SCT, SCT_OUTPUT_4 ,SCT_RES_TOGGLE_OUTPUT);	// output 4 toggles on conflict

		Chip_SCT_ClearControl(LPC_SCT,SCT_CTRL_HALT_L);               			  				// start timer
}


int main(void)
{
	SystemCoreClockUpdate();
	Board_Init();


	Chip_IOCON_PinMuxSet(LPC_IOCON, 1, 10, IOCON_FUNC3 | IOCON_MODE_INACT | IOCON_DIGITAL_EN | IOCON_INPFILT_OFF);		//SCT0_OUT4 = P1.10  (green   LED)


	SCT_Init();																			// Initialize SCT

	while (1)                                       // loop forever
	{
		__WFI();
	}
}


